# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 3
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def sunshine_trust_builder(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial phase: build trust with cooperation
    current_round = len(my_history)
    if current_round < 2:
        return "C"
    
    # Grim trigger if opponent defects early
    if "D" in opp_history[:2]:
        return "D"
    
    # Mid-game: alternate C/D to confuse opponent
    if 2 <= current_round <= 5:
        return "D" if current_round % 2 == 0 else "C"
    
    # Exploit consistent cooperation
    if 6 <= current_round <= 8:
        if all(m == "C" for m in opp_history[2:6]):
            return "D"
        else:
            return "C" if opp_history[-1] == "D" else "D"
    
    # Final round: always defect
    if current_round == 9:
        return "D"
    
    # Default to cooperation (should never reach here)
    return "C"